#include "sierrachart.h"

SCDLLName("Simple MA Crossover")

void SetTradingDefaults(SCStudyInterfaceRef sc)
{
	sc.MaximumPositionAllowed = 1000;
}

//is called for every bar
void Process(SCStudyGraphRef sc)
{
	SCInputRef fastMAPeriod = sc.Input[0];
	SCInputRef slowMAPeriod = sc.Input[1];
	SCInputRef positionSize = sc.Input[2];
	SCInputRef signalArrowOffset = sc.Input[3];

	SCSubgraphRef fastMA = sc.Subgraph[0];
	SCSubgraphRef slowMA = sc.Subgraph[1];
	SCSubgraphRef shortSignalArrow = sc.Subgraph[2];
	SCSubgraphRef longSignalArrow = sc.Subgraph[3];


	if (sc.SetDefaults)
	{
		sc.GraphName = "Simple MA Crossover";
		sc.StudyDescription = "";

		sc.AutoLoop = 1;
		sc.GraphRegion = 0;
		sc.SupportAttachedOrdersForTrading = 1;
		sc.UseGUIAttachedOrderSetting = true;

		fastMAPeriod.Name = "Fast MA Period (Bars)";
		fastMAPeriod.SetInt(10);

		slowMAPeriod.Name = "Slow MA Period (Bars)";
		slowMAPeriod.SetInt(20);

		positionSize.Name = "Position Size";
		positionSize.SetInt(2);

		signalArrowOffset.Name = "Signal Arrow Offset";
		signalArrowOffset.SetFloat(0.5);

		fastMA.Name = "Fast MA";
		fastMA.PrimaryColor = COLOR_PURPLE;
		fastMA.DrawStyle = DRAWSTYLE_LINE;
		slowMA.Name = "Slow MA";
		slowMA.PrimaryColor = COLOR_PINK;
		slowMA.DrawStyle = DRAWSTYLE_LINE;

		shortSignalArrow.Name = "Short Signal";
		shortSignalArrow.PrimaryColor = COLOR_LIME;
		shortSignalArrow.DrawStyle = DRAWSTYLE_ARROWDOWN;

		longSignalArrow.Name = "Long Signal";
		longSignalArrow.PrimaryColor = COLOR_LIME;
		longSignalArrow.DrawStyle = DRAWSTYLE_ARROWUP;

		return;
	}
	if (sc.Index == 0)
	{
		SetTradingDefaults(sc);
	}

	if (sc.GetBarHasClosedStatus() == BHCS_BAR_HAS_NOT_CLOSED)
	{
		return;
	}
	
	// Calculate indicators
	sc.MovingAverage(sc.BaseData[SC_LAST], fastMA, MOVAVGTYPE_SIMPLE, sc.Index, fastMAPeriod.IntValue);
	sc.MovingAverage(sc.BaseData[SC_LAST], slowMA, MOVAVGTYPE_SIMPLE, sc.Index, slowMAPeriod.IntValue);

	s_SCPositionData currentPosition;

	sc.GetTradePosition(currentPosition);


	// Calculate signals
	bool longSignal = false;
	bool shortSignal = false;
	int crossover = sc.CrossOver(fastMA, slowMA);
	if (crossover == CROSS_FROM_BOTTOM) {
		// Long signal
		longSignal = true;
	}
	else if (crossover == CROSS_FROM_TOP) {
		// Short signal
		shortSignal = true;
	}


	if (currentPosition.PositionQuantity == 0)
	{

		s_SCNewOrder order;

		if (longSignal)
		{
			order.OrderQuantity = positionSize.IntValue;


			sc.BuyOrder(order);

			longSignalArrow[sc.Index] = sc.BaseData[SC_LOW][sc.Index] - signalArrowOffset.FloatValue;

		}
		else if (shortSignal)
		{
			order.OrderQuantity = positionSize.IntValue;

			sc.SellOrder(order);

			shortSignalArrow[sc.Index] = sc.BaseData[SC_HIGH][sc.Index] + signalArrowOffset.FloatValue;

		}
	}

	return;
}

SCSFExport scsf_simple_ma_crossover(SCStudyInterfaceRef sc)
{
	Process(sc);
}